***
*** Definicin de constantes para el manejo del Registro de Configuraciones
***


*** Tipo no definido
#define REG_NONE                      0
*** Cadena de caracteres
#define REG_SZ                        1
*** Binario
#define REG_BINARY					  3
*** Nmero de 32 bits
#define REG_DWORD                     4
*** Nmero de 32 bits 
*** con formato Little-Endian
#define REG_DWORD_LITTLE_ENDIAN       4
*** Nmero de 32 bits 
*** con formato Big-Endian
#define REG_DWORD_BIG_ENDIAN          5
**** Enlace simblico de Unicode
#define REG_LINK                      6
*** Matriz de cadenas
#define REG_MULTI_SZ                  7
*** Lista de recursos de dispositivo
#define REG_RESOURCE_LIST             8

*** Claves principales
#DEFINE HKEY_CLASSES_ROOT   -2147483648
#DEFINE HKEY_CURRENT_USER   -2147483647
#DEFINE HKEY_LOCAL_MACHINE  -2147483646
#DEFINE HKEY_USERS          -2147483645
#DEFINE HKEY_CURRENT_CONFIG -2147483653
#DEFINE HKEY_DYN_DATA       -2147483654

*** Tipos de acceso
#define KEY_QUERY_VALUE               1
#define KEY_SET_VALUE                 2
#define KEY_CREATE_SUB_KEY            4
#define KEY_ENUMERATE_SUB_KEYS        8
#define KEY_NOTIFY                   16
#define KEY_CREATE_LINK              32
#define KEY_READ                       KEY_QUERY_VALUE + KEY_ENUMERATE_SUB_KEYS + KEY_NOTIFY
#define KEY_WRITE                      KEY_SET_VALUE + KEY_CREATE_SUB_KEY
#define KEY_EXECUTE                    KEY_READ
#define KEY_ALL_ACCESS                 KEY_QUERY_VALUE + KEY_SET_VALUE + KEY_CREATE_SUB_KEY + KEY_ENUMERATE_SUB_KEYS + KEY_NOTIFY + KEY_CREATE_LINK

*** Opciones de creacin
#DEFINE REG_OPTION_NON_VOLATILE       0  && La clave se conserva al reiniciar el sistema
#DEFINE REG_OPTION_VOLATILE           1  && La clave no se conserva al reiniciar el sistema

*** Retornos de RegCreateKeyEx()
#DEFINE REG_CREATED_NEW_KEY           1  && Creada clave de registro nueva
#DEFINE REG_OPENED_EXISTING_KEY       2  && Abierta clave existente 


*** Posible retornos de las funciones

*** OK
#define NO_ERROR 0

*** The system cannot find the key specified.
#define ERROR_FILE_NOT_FOUND             2

***  The configuration registry database is corrupt.
#define ERROR_BADDB                      1009

*** The configuration registry key is invalid.
#define ERROR_BADKEY                     1010

*** The configuration registry key could not be opened.
#define ERROR_CANTOPEN                   1011

*** The configuration registry key could not be read.
#define ERROR_CANTREAD                   1012

*** The configuration registry key could not be written.
#define ERROR_CANTWRITE                  1013

*** One of the files in the Registry database had to be recovered
*** by use of a log or alternate copy.  The recovery was successful.
#define ERROR_REGISTRY_RECOVERED         1014

*** The Registry is corrupt. The structure of one of the files that contains
*** Registry data is corrupt, or the system's image of the file in memory
*** is corrupt, or the file could not be recovered because the alternate
*** copy or log was absent or corrupt.
#define ERROR_REGISTRY_CORRUPT           1015

*** An I/O operation initiated by the Registry failed unrecoverably.
*** The Registry could not read in, or write out, or flush, one of the files
*** that contain the system's image of the Registry.
#define ERROR_REGISTRY_IO_FAILED         1016

*** The system has attempted to load or restore a file into the Registry, but the
*** specified file is not in a Registry file format.
#define ERROR_NOT_REGISTRY_FILE          1017

*** Illegal operation attempted on a Registry key which has been marked for deletion.
#define ERROR_KEY_DELETED                1018

*** System could not allocate the required space in a Registry log.
#define ERROR_NO_LOG_SPACE               1019

*** Cannot create a symbolic link in a Registry key that already
*** has subkeys or values.
#define ERROR_KEY_HAS_CHILDREN           1020

***  Cannot create a stable subkey under a volatile parent key.
#define ERROR_CHILD_MUST_BE_VOLATILE     1021

